local addOnName = ...
--SAVED VARIABLES
--holds the initial states for all the buttons, true by default as hard coded in, on addon reload it updates this list when all variables are loaded
madness_whisperStates = {
	["yoggState"] = true,
	["cthunState"] = true,
	["yshaarjState"] = true,
	["voidState"] = true,
}
--madness_Timer for the whispers
madness_Timer = 120 -- interval in seconds
------------- SOUND LIBRARY SETUP ------------------------------------------------------

--Sound libraries, loose varients have the audio file numbers and not the audio file pathways.
local yoggSounds = {
	"Sound\\Creature\\YoggSaron\\AK_YoggSaron_HowlingFjordWhisper01.ogg",
	"Sound\\Creature\\YoggSaron\\AK_YoggSaron_HowlingFjordWhisper02.ogg",
	"Sound\\Creature\\YoggSaron\\AK_YoggSaron_HowlingFjordWhisper03.ogg",
	"Sound\\Creature\\YoggSaron\\AK_YoggSaron_HowlingFjordWhisper04.ogg",
	"Sound\\Creature\\YoggSaron\\AK_YoggSaron_HowlingFjordWhisper05.ogg",
	"Sound\\Creature\\YoggSaron\\AK_YoggSaron_HowlingFjordWhisper06.ogg",
	"Sound\\Creature\\YoggSaron\\AK_YoggSaron_HowlingFjordWhisper07.ogg",
	"Sound\\Creature\\YoggSaron\\AK_YoggSaron_HowlingFjordWhisper08.ogg",
	"Sound\\Creature\\YoggSaron\\AK_YoggSaron_Whisper01.ogg",
	"Sound\\Creature\\YoggSaron\\AK_YoggSaron_Whisper02.ogg",
	"Sound\\Creature\\YoggSaron\\AK_YoggSaron_Whisper03.ogg",
	"Sound\\Creature\\YoggSaron\\AK_YoggSaron_Whisper04.ogg",
	"Sound\\Creature\\YoggSaron\\UR_YoggSaron_Slay01.ogg",
	"Sound\\Creature\\YoggSaron\\UR_YoggSaron_Slay02.ogg",
	"Sound\\Creature\\YoggSaron\\UR_YoggSaron_YSVisThree01.ogg",
	"Sound\\Creature\\YoggSaron\\UR_YoggSaron_YSVisOne02.ogg",
	"Sound\\Creature\\YoggSaron\\UR_YoggSaron_YSVisOne03.ogg",
	"Sound\\Creature\\YoggSaron\\UR_YoggSaron_Tentacle01.ogg",
	"Sound\\Creature\\YoggSaron\\UR_YoggSaron_Insanity02.ogg",
	"Sound\\Creature\\YoggSaron\\UR_YoggSaron_Insanity01.ogg",
	
}
local looseYoggSounds = {
	23414
}
local CThunSounds = {
	"Sound\\Creature\\CThun\\CThunDeathIsClose.ogg",
	"Sound\\Creature\\CThun\\CThunYouAreAlready.ogg",
	"Sound\\Creature\\CThun\\CThunYouWillBetray.ogg",
	"Sound\\Creature\\CThun\\CThunYouWillDie.ogg",
	"Sound\\Creature\\CThun\\CThunYourCourage.ogg",
	"Sound\\Creature\\CThun\\CThunYourFriends.ogg",
	"Sound\\Creature\\CThun\\YouAreWeak.ogg",
	"Sound\\Creature\\CThun\\YourHeartWill.ogg",
}
local looseCThunSounds = {
	8699,
	8698,
	8697,
}
local yShaarjsounds = {
	"Sound\\Creature\\Yshaarj\\VO_53_Yshaarj_Scenario_LowHealth_05.ogg",
	"Sound\\Creature\\Yshaarj\\VO_53_Yshaarj_Scenario_Kill_04.ogg",
	"Sound\\Creature\\Yshaarj\\VO_53_Yshaarj_Scenario_Death_07.ogg",
	"Sound\\Creature\\Yshaarj\\VO_53_Yshaarj_Scenario_Adds_02.ogg",
	"Sound\\Creature\\Yshaarj\\VO_54_ITEM_YSHAARJ_DEATH_02.ogg",
	"Sound\\Creature\\Yshaarj\\VO_54_ITEM_YSHAARJ_DEATH_01.ogg",
	"Sound\\Creature\\Yshaarj\\VO_53_Yshaarj_Scenario_LowHealth_07.ogg",
	"Sound\\Creature\\Yshaarj\\VO_54_ITEM_YSHAARJ_EVENT_04.ogg",
	"Sound\\Creature\\Yshaarj\\VO_54_ITEM_YSHAARJ_EVENT_03.ogg",
	"Sound\\Creature\\Yshaarj\\VO_54_ITEM_YSHAARJ_EVENT_02.ogg",
	"Sound\\Creature\\Yshaarj\\VO_54_ITEM_YSHAARJ_EVENT_01.ogg",
	"Sound\\Creature\\Yshaarj\\VO_54_ITEM_YSHAARJ_DEATH_03.ogg",
	"Sound\\Creature\\Yshaarj\\VO_54_ITEM_YSHAARJ_EVENT_05.ogg",
	"Sound\\Creature\\Yshaarj\\VO_54_ITEM_YSHAARJ_EVENT_07.ogg",
	"Sound\\Creature\\Yshaarj\\VO_54_ITEM_YSHAARJ_EVENT_06.ogg",
	"Sound\\Creature\\Yshaarj\\VO_54_OR_YSHAARJ_EVENT_8.ogg",
	"Sound\\Creature\\Yshaarj\\VO_54_OR_YSHAARJ_EVENT_7.ogg",
	"Sound\\Creature\\Yshaarj\\VO_54_OR_YSHAARJ_EVENT_6.ogg",
	"Sound\\Creature\\Yshaarj\\VO_54_OR_YSHAARJ_EVENT_5.ogg",
	"Sound\\Creature\\Yshaarj\\VO_54_OR_YSHAARJ_EVENT_4.ogg",
	"Sound\\Creature\\Yshaarj\\VO_54_OR_YSHAARJ_EVENT_3.ogg",
	"Sound\\Creature\\Yshaarj\\VO_54_OR_YSHAARJ_EVENT_2.ogg",
	"Sound\\Creature\\Yshaarj\\VO_54_OR_YSHAARJ_EVENT_1.ogg",
	"Sound\\Creature\\Yshaarj\\VO_54_ITEM_YSHAARJ_EVENT_13.ogg",
	"Sound\\Creature\\Yshaarj\\VO_54_ITEM_YSHAARJ_EVENT_12.ogg",
	"Sound\\Creature\\Yshaarj\\VO_54_ITEM_YSHAARJ_EVENT_11.ogg",
	"Sound\\Creature\\Yshaarj\\VO_54_ITEM_YSHAARJ_EVENT_10.ogg",
	"Sound\\Creature\\Yshaarj\\VO_54_ITEM_YSHAARJ_EVENT_09.ogg",
	"Sound\\Creature\\Yshaarj\\VO_54_ITEM_YSHAARJ_EVENT_08.ogg",
	
}
local voidSounds = {
	62356,
	62379,
	62389,
	62401,
	62390,
	31261,
	31266,
	31254,
	9812,
	9809,
	9811,
	47900,
	
}
local sounds = {}

--Searches the 'source' table for the 'toFind' item and returns the location index 
--of it
function table_search(toFind, source)
local loc = 0;
--print ("Libraries in Source Table: ",table.getn(source))
   for _, v in pairs (source) do
		if (v == toFind) then
			loc = loc + 1
			break
		else
			loc = loc + 1
		end
     end
	 if (loc > 0) then
	 return loc;
	 end
end

--function for listing out the tables, TEST FUNCTION
function list_table(source)
local loc = 0;
print ("Tables in Source Table: ")
   for key, value in pairs(source) do
	print (key)
   end
end

--returns the number of items within a 'source' table, TEST FUNCTION
function active_items(source)
	 return table.getn(source);
end

------------- PANEL SETUP ------------------------------------------------------
-- main panel
local panel = CreateFrame("Frame")
panel.name = addOnName

panel.okay = function(self)
local val = editbox:GetText()
	if tonumber(val) then
	sliderMin, sliderMax = madness_Slider:GetMinMaxValues()
		if (tonumber(val) >= sliderMin and tonumber(val) <= sliderMax) then
			madness_Slider:SetValue(val)
			madness_Timer = val;
			editbox:ClearFocus()
		end
	else
		editbox:ClearFocus()
	end
end

panel.default = function(self)
	madness_Timer = 120;
	madness_Slider:SetValue(madness_Timer)
	editbox:ClearFocus()
	madness_whisperStates.yoggState = true;
	madness_whisperStates.cthunState = true;
	madness_whisperStates.yshaarjState = true;
	madness_whisperStates.voidState = true;
	yoggButton:SetChecked(madness_whisperStates.yoggState)
	cThunButton:SetChecked(madness_whisperStates.cthunState)
	yShaarjButton:SetChecked(madness_whisperStates.yshaarjState)
	whispersButton:SetChecked(madness_whisperStates.voidState)
end
InterfaceOptions_AddCategory(panel)


-- adds in the title of the addon
local title = panel:CreateFontString(nil, "ARTWORK", "GameFontNormalLarge")
title:SetTextColor(.57, .15, .94)
title:SetPoint("CENTER", 0, 250)
title:SetText(addOnName)

--first flavor text
local firsttext = panel:CreateFontString(nil, "ARTWORK", "GameFontHighlightSmall")
firsttext:SetPoint("CENTER", title, "CENTER", 0, -15)
firsttext:SetText("... The Void sees all possible futures ...")
firsttext:SetTextColor(.137, .70, .655)

--second flavor text, under first
local secondtext = panel:CreateFontString(nil, "ARTWORK", "GameFontHighlightSmall")
secondtext:SetPoint("CENTER", firsttext, "CENTER", 0, -15)
secondtext:SetText("... And believes them all to be true ...")
secondtext:SetTextColor(.137, .70, .655)

-- Adds in the header for the voices section
local voices = panel:CreateFontString(nil, "ARTWORK", "GameFontNormalLarge")
voices:SetPoint("TOPLEFT", 16, -94)
voices:SetText("Voices of the Old Gods")

--Setting up Buttons

--IF THE SAVE VARIABLE DOES NOT EXIST, CREATES IT (HOLDS THE BOOLEANS FOR BUTTON STATES)
if not madness_whisperStates then
	madness_whisperStates = {}
end

--onLoad function loads after the addon has fully loaded, loads in the SaveVariables and calls the initalize to populate the library
local function onLoad(_, event, arg1)
	if (event == "ADDON_LOADED") then
			--print ("Something atleast happened")
		if madness_whisperStates.yoggState == nil then
			--buttonStates.yoggState = true
			print ("Error with addon Madness of the Void")
		else
			--print ("yoggState: ", madness_whisperStates.yoggState)
		end
		if madness_whisperStates.cthunState == nil then
			print ("Error with addon Madness of the Void")
		else
			--print ("cthunState: ", madness_whisperStates.cthunState)
		end
		if madness_whisperStates.yshaarjState == nil then
			print ("Error with addon Madness of the Void")
		else
			--print ("cthunState: ", madness_whisperStates.yshaarjState)
		end
		if madness_whisperStates.voidState == nil then
			print ("Error with addon Madness of the Void")
		else
			--print ("cthunState: ", madness_whisperStates.voidState)
		end
		yoggButton:SetChecked(madness_whisperStates.yoggState)
		cThunButton:SetChecked(madness_whisperStates.cthunState)
		yShaarjButton:SetChecked(madness_whisperStates.yshaarjState)
		whispersButton:SetChecked(madness_whisperStates.voidState)
		initSounds()
		madness_Slider:SetValue(madness_Timer)
		editbox:SetCursorPosition(0)
		panel:UnregisterEvent(event)
	else
		--print (arg1)
	end
end

panel:RegisterEvent("ADDON_LOADED")
panel:SetScript("OnEvent", onLoad)

	--Yogg Saron Button
yoggButton = CreateFrame("CheckButton", "yoggButton_GlobalName", panel, "ChatConfigCheckButtonTemplate");
yoggButton:SetPoint("TOPLEFT", voices, "BOTTOMLEFT", 12, -12);
yoggButton_GlobalNameText:SetText(" Madness of Yogg Saron");
yoggButton.tooltip = "Check to enable the voices of Yogg Saron (Checked by Default)";
yoggButton:SetScript("OnClick", 
  function(self)
			local checker = yoggButton:GetChecked()
			if checker then
				PlaySound(856) -- Check Click Sound
				table.insert(sounds, yoggSounds)
				table.insert(sounds, looseYoggSounds)
				madness_whisperStates.yoggState = yoggButton:GetChecked()
				--print ("yoggState: ", madness_whisperStates.yoggState)
			else
				PlaySound(857) -- Check Unclick Sound
				--print("toFind Table at Index: ",table_search(yoggSounds, sounds))
				table.remove(sounds, tonumber(table_search(yoggSounds, sounds)))
				table.remove(sounds, tonumber(table_search(looseYoggSounds, sounds)))
				madness_whisperStates.yoggState = yoggButton:GetChecked()
				--print ("yoggState: ", madness_whisperStates.yoggState)
			end
	end);
	
	
	
	--C'Thun Button
cThunButton = CreateFrame("CheckButton", "cThunButton_GlobalName", panel, "ChatConfigCheckButtonTemplate");
cThunButton:SetPoint("TOPLEFT", yoggButton, "BOTTOMLEFT", 0, -12);
cThunButton_GlobalNameText:SetText(" Madness of C'Thun");
cThunButton.tooltip = "Check to enable the voices of C'Thun (Checked by Default)";
cThunButton:SetChecked(true);
cThunButton:SetScript("OnClick", 
  function(self)
  			local checker = cThunButton:GetChecked()
			if checker then
				PlaySound(856) -- SOUNDKIT.IG_MAINMENU_OPTION_CHECKBOX_ON
				table.insert(sounds, CThunSounds)
				table.insert(sounds, looseCThunSounds)
				madness_whisperStates.cthunState = cThunButton:GetChecked()
				--print ("cthunState: ", madness_whisperStates.cthunState)
			else
				PlaySound(857) -- SOUNDKIT.IG_MAINMENU_OPTION_CHECKBOX_OFF
				--print("toFind Table at Index: ",table_search(CThunSounds, sounds))
				table.remove(sounds, tonumber(table_search(CThunSounds, sounds)))
				table.remove(sounds, tonumber(table_search(looseCThunSounds, sounds)))
				madness_whisperStates.cthunState = cThunButton:GetChecked()
				--print ("cthunState: ", madness_whisperStates.cthunState)
			end
  end
);


	--Y'Shaarj Button
yShaarjButton = CreateFrame("CheckButton", "yShaarjButton_GlobalName", panel, "ChatConfigCheckButtonTemplate");
yShaarjButton:SetPoint("TOPLEFT", cThunButton, "BOTTOMLEFT", 0, -12);
yShaarjButton_GlobalNameText:SetText(" Madness of Y'Shaarj");
yShaarjButton.tooltip = "Check to enable the voices of Y'Shaarj (Checked by Default)";
yShaarjButton:SetChecked(true);
yShaarjButton:SetScript("OnClick", 
  function(self)
  			local checker = yShaarjButton:GetChecked()
			if checker then
				PlaySound(856) -- SOUNDKIT.IG_MAINMENU_OPTION_CHECKBOX_ON
				table.insert(sounds, yShaarjsounds)
				madness_whisperStates.yshaarjState = yShaarjButton:GetChecked()
				--print ("yshaarjState: ", madness_whisperStates.yshaarjState)
			else
				PlaySound(857) -- SOUNDKIT.IG_MAINMENU_OPTION_CHECKBOX_OFF
				--print("toFind Table at Index: ",table_search(yShaarjsounds, sounds))
				table.remove(sounds, tonumber(table_search(yShaarjsounds, sounds)))
				madness_whisperStates.yshaarjState = yShaarjButton:GetChecked()
				--print ("yshaarjState: ", madness_whisperStates.yshaarjState)
			end
  end
);

	--Whispers of the Void Button
whispersButton = CreateFrame("CheckButton", "whispersButton_GlobalName", panel, "ChatConfigCheckButtonTemplate");
whispersButton:SetPoint("TOPLEFT", yShaarjButton, "BOTTOMLEFT", 0, -12);
whispersButton_GlobalNameText:SetText(" Whispers of the Void");
whispersButton.tooltip = "Check to enable additional void audio (Checked by Default)";
whispersButton:SetChecked(true);
whispersButton:SetScript("OnClick", 
  function(self)
  			local checker = whispersButton:GetChecked()
			if checker then
				PlaySound(856) -- SOUNDKIT.IG_MAINMENU_OPTION_CHECKBOX_ON
				table.insert(sounds, voidSounds)
				madness_whisperStates.voidState = whispersButton:GetChecked()
				--print ("yshaarjState: ", madness_whisperStates.yshaarjState)
			else
				PlaySound(857) -- SOUNDKIT.IG_MAINMENU_OPTION_CHECKBOX_OFF
				table.remove(sounds, tonumber(table_search(voidSounds, sounds)))
				madness_whisperStates.voidState = whispersButton:GetChecked()
				--print ("yshaarjState: ", madness_whisperStates.yshaarjState)
			end
  end
);
 
	--Create text for the slider
local madness_Timertext = panel:CreateFontString(nil, "ARTWORK", "GameFontHighlightMedium")
madness_Timertext:SetPoint("BOTTOMLEFT", 30, 250)
madness_Timertext:SetText("Madness Timer (seconds): ")
madness_Timertext:SetTextColor(.130, .70, .655)

	--Creating the Slider for the madness_Timer
 madness_Slider = CreateFrame("Slider", "madness_SliderGlobalName", panel, "OptionsSliderTemplate")
 madness_Slider:SetWidth(175)
 madness_Slider:SetHeight(20)
 madness_Slider:SetOrientation('HORIZONTAL')
 madness_Slider:SetPoint("CENTER", madness_Timertext, 190, 0);
 madness_Slider.tooltipText = 'Set the timer for audio playback' --Creates a tooltip on mouseover.
 getglobal(madness_Slider:GetName() .. 'Low'):SetText('10'); --Sets the left-side slider text
 getglobal(madness_Slider:GetName() .. 'High'):SetText('1800'); --Sets the right-side slider text
 madness_Slider:SetValueStep(1)
 madness_Slider:SetMinMaxValues(10, 1800)
 madness_Slider:SetObeyStepOnDrag(obeyStep)
 madness_Slider:SetValue(120)
 
	--Creating editbox to show number for the slider
 editbox = CreateFrame("EditBox", "InputBoxTemplateTest", panel, "InputBoxTemplate")
 editbox:ClearAllPoints()
 editbox:ClearFocus()
 editbox:SetSize(70, 30)
 editbox:SetPoint("LEFT", madness_Slider, "RIGHT", 15, 0)
 editbox:SetText(madness_Slider:GetValue())
 editbox:SetAutoFocus(false)
 editbox:SetCursorPosition(0)
 
 --Scripts for changing the Slider Values and text box values
 
	--Slider <- Edit Box
 madness_Slider:SetScript("OnValueChanged", function(self, value)
	madness_Timer = (floor(value))
	editbox:SetText(floor(value))
	end)
 
	--Edit Box -> Slider
 editbox:SetScript("OnEnterPressed", function(self)
	local val = self:GetText()
	if tonumber(val) then
	sliderMin, sliderMax = madness_Slider:GetMinMaxValues()
		if (tonumber(val) >= sliderMin and tonumber(val) <= sliderMax) then
			madness_Slider:SetValue(val)
			madness_Timer = val;
			self:ClearFocus()
		end
	else
		self:ClearFocus()
	end
end)
 

	
-- POPULATE AUDIO LIBRARY ON INITIAL ------------------------------------------------------
function initSounds()
	if (yoggButton:GetChecked(true)) then
	table.insert(sounds, yoggSounds)
	table.insert(sounds, looseYoggSounds)
	end
	if (cThunButton:GetChecked(true)) then
	table.insert(sounds, CThunSounds)
	table.insert(sounds, looseCThunSounds)
	end
	if (yShaarjButton:GetChecked(true)) then
	table.insert(sounds, yShaarjsounds)
	end
	if (whispersButton:GetChecked(true)) then
	table.insert(sounds, voidSounds)
	end
end
	

	-- TEST LINES FOR LIBRARY TRACKING ------------------------------------------------------
--local TableSize = panel:CreateFontString(nil, "ARTWORK", "GameFontHighlightSmall")
--TableSize:SetPoint("CENTER", secondtext, "CENTER", 0, -15)
--TableSize:SetText("Active Libraries: " .. table.getn(sounds))

--function update_testLine()
--TableSize:SetText("Active Libraries: " .. tonumber(active_items(sounds)))
--end

------------- AUDIO PLAYER ------------------------------------------------------
local madnessVoices = CreateFrame("Frame")
local tslu = 0
madnessVoices:SetScript("OnUpdate", function(holder, elapsed)
	tslu = tslu + elapsed
	if tslu > tonumber(madness_Timer) then
		if (table.getn(sounds) > 0) then		
			tslu = 0
			selectTable = sounds[math.random(#sounds)]
			--print ("Selected Table Entries: ", tonumber(active_items(selectTable)))
			selectAudio = selectTable[math.random(#selectTable)]
			--print ("Selected Entry: ", selectAudio)
			if (tonumber(selectAudio) == nil) then
					PlaySoundFile(selectAudio)
				else
					PlaySound(selectAudio)
			end
			--update_testLine();
			--list_table(sounds);
			--print("madness_Timer: ", madness_Timer)
		else
			tslu = 0
			--update_testLine();
			--list_table(sounds);
			--print("madness_Timer: ", madness_Timer)
		end
	end
end)